import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class MouseEventProcessor
{
	private Point MousePosLast;
	private boolean MouseLeftButtonDown;
	private boolean MouseRightButtonDown;
	private boolean MouseLeftButtonClicked;
	private boolean MouseRightButtonClicked;
	private boolean MouseMoved;
	private boolean MouseDragged;
	private boolean MouseWheelTurnedUp;
	private boolean MouseWheelTurnedDown;

	public MouseEventProcessor(MainWindow MainWindow)
	{
		MousePosLast = new Point(0, 0);
		MouseLeftButtonDown = false;
		MouseRightButtonDown = false;
		MouseLeftButtonClicked = false;
		MouseRightButtonClicked = false;
		MouseMoved = false;
		MouseDragged = false;
	}

	public boolean AnyButtonPressed()
	{
		return (IsLeftButtonDown() || IsRightButtonDown());
	}

	public void ClearMouseButtonClicked()
	{
		MouseLeftButtonClicked = false;
		MouseRightButtonClicked = false;
	}

	public void ClearMouseButtonDown()
	{
		MouseLeftButtonDown = false;
		MouseRightButtonDown = false;
	}
	
	public Point GetMousePosPoint(MainWindow MainWindow)
	{
		 // Insets are general window elements like title bar (docs on the Internet say)
		return new Point(MousePosLast.x - MainWindow.getInsets().left, MousePosLast.y - MainWindow.getInsets().top);
	}

	public boolean IsLeftButtonClicked()
	{
		return MouseLeftButtonClicked;
	}

	public boolean IsLeftButtonDown()
	{
		return MouseLeftButtonDown;
	}

	public boolean IsMouseDragged()
	{
		return MouseDragged;
	}

	public boolean IsMouseMoved()
	{
		return MouseMoved;
	}

	public boolean IsRightButtonClicked()
	{
		return MouseRightButtonClicked;
	}

	public boolean IsRightButtonDown()
	{
		return MouseRightButtonDown;
	}

	public void mouseClicked(MouseEvent e)
	{
		MousePosLast = e.getPoint();

		if (e.getButton() == MouseEvent.BUTTON1)
			MouseLeftButtonClicked = true;
		if (e.getButton() == MouseEvent.BUTTON3)
			MouseRightButtonClicked = true;

		MouseMoved = false;
		MouseDragged = false;
	}

	public void mouseDragged(MouseEvent e)
	{
		MousePosLast = e.getPoint();

		MouseLeftButtonClicked = false;
		MouseRightButtonClicked = false;

		MouseMoved = false;
		MouseDragged = true;
	}

	public void mouseMoved(MouseEvent e)
	{
		MousePosLast = e.getPoint();

		MouseLeftButtonClicked = false;
		MouseRightButtonClicked = false;

		MouseMoved = true;
		MouseDragged = false;
	}

	public void mousePressed(MouseEvent e)
	{
		// when it's pressed, it's not YET clicked (else system screwed, tested)!
		MouseLeftButtonClicked = false;
		MouseRightButtonClicked = false;

		MousePosLast = e.getPoint();

		if (e.getButton() == MouseEvent.BUTTON1)
			MouseLeftButtonDown = true;
		if (e.getButton() == MouseEvent.BUTTON3)
			MouseRightButtonDown = true;

		MouseMoved = false;
		MouseDragged = false;
	}

	public void mouseReleased(MouseEvent eOrNull)
	{
		// when it's released, it's not YET clicked (else system screwed, tested)!
		MouseLeftButtonClicked = false;
		MouseRightButtonClicked = false;

		// if left button is released, don't release right one, else
		// Selection cannot be sized after Grid has been moved!

		if (eOrNull != null)
		{
			if (eOrNull.getButton() == MouseEvent.BUTTON1)
				MouseLeftButtonDown = false;
			if (eOrNull.getButton() == MouseEvent.BUTTON3)
				MouseRightButtonDown = false;
		}
		else
		{
			MouseLeftButtonDown = false;
			MouseRightButtonDown = false;
		}

		MouseMoved = false;
		MouseDragged = false;
	}

	public void mouseWheelMoved(MouseWheelEvent e)
	{
		// https://docs.oracle.com/javase/tutorial/uiswing/events/mousewheellistener.html

		int notches = e.getWheelRotation();
		if (notches > 0)
		{
			MouseWheelTurnedUp = true;
		}
		if (notches < 0)
		{
			MouseWheelTurnedDown = true;
		}
	}

	public boolean NoButtonPressed()
	{
		return !AnyButtonPressed();
	}

	public void ResetMouseWheel()
	{
		MouseWheelTurnedUp = false;
		MouseWheelTurnedDown = false;
	}

	public boolean WasMouseWheelTurned()
	{
		return (WasMouseWheelTurnedUp() || WasMouseWheelTurnedDown());
	}

	public boolean WasMouseWheelTurnedDown()
	{
		return MouseWheelTurnedDown;
	}

	public boolean WasMouseWheelTurnedUp()
	{
		return MouseWheelTurnedUp;
	}
}
